/************************************************************************
 *
 * \file: Testbed.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Demo application
 *
 * \author: Bui Le Thuan / RBVH/ENG2 / Thuan.BuiLe@vn.bosch.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#include "Testbed.h"
#include <adit_logging.h>

LOG_IMPORT_CONTEXT(demo)

namespace adit { namespace aauto {

Testbed::Testbed() {
    // TODO Auto-generated constructor stub
    testbedMode = false;
    surfaceID = 0;
    layerID = 0;
    tb_aauto_g_main_loop_ctx = nullptr;

    devStat = INIT;
    videoChannel = nullptr;
}

Testbed::~Testbed() {
    // TODO Auto-generated destructor stub
    if (tb_aauto_g_main_loop_ctx != nullptr)
    {
        //delete tb_aauto_g_main_loop_ctx;
        tb_aauto_g_main_loop_ctx = nullptr;
    }

    if (videoChannel != nullptr)
    {
        videoChannel = nullptr;
    }

    devStat = INIT;
}

void Testbed::setTestbedMode(bool inTestbedMode)
{
    testbedMode = inTestbedMode;
}

bool Testbed::getTestbedMode()
{
    return testbedMode;
}

int Testbed::getSurfaceID()
{
    return surfaceID;
}

int Testbed::getLayerID()
{
    return layerID;
}

void Testbed::setVideoChannel(VideoChannel* inVideoChannel)
{
    videoChannel = inVideoChannel;
}

VideoChannel* Testbed::getVideoChannel()
{
    return videoChannel;
}

void Testbed::adit_testbed_init()
{
    // Fixed surface ID and layerID on AAuto Testbed Application
    surfaceID = 252;
    layerID = 1;

    // Add callback functions
    const tba_callbacks_t callbacks_TB =
    {
            .state_changed_cb = state_changed_TB,
            .entering_shutdown_cb = entering_shutdown_TB,
            .waking_up_cb = waking_up_TB,
            .log_event_cb = log_event_TB,
            .surface_id_received_cb = surface_id_received_TB,
            .surface_id_invalid_cb = surface_id_invalid_TB
    };

    //init application framework
    tb_aauto_g_main_loop_ctx = g_main_loop_new(NULL, false);
    LOG_INFO((demo, "g_main_loop_ctx = %p\n", tb_aauto_g_main_loop_ctx));

    if (libtestbedapp_init(false,"com.adit.testbed.aautoApp",TBA_LOGLEVEL_ERROR,20000,&callbacks_TB, this)!=TBA_RESULT_OK)
    {
        LOG_INFO((demo, "Testbed library initialization failed.\n"));
    }
    else
    {
        LOG_INFO((demo, "Initialized of Testbed App.\n"));
    }

    if (ILM_SUCCESS != ilm_init())
    {
        LOG_ERROR((demo, "%s - ilm_init failed", __FUNCTION__));
    }
    else
    {
        LOG_INFO((demo, "%s - ilm_init SUCCEEDED", __FUNCTION__));
    }
}

void Testbed::adit_testbed_run()
{
    LOG_INFO((demo, "Running Testbed App...\n"));
    g_main_loop_run(tb_aauto_g_main_loop_ctx);
    LOG_INFO((demo, "Shutting down Testbed App...\n"));
}

void Testbed::adit_testbed_deinit()
{
    libtestbedapp_deinit();
    if (tb_aauto_g_main_loop_ctx!=NULL)
    {
        g_main_loop_quit(tb_aauto_g_main_loop_ctx);
    }
    LOG_INFO((demo, "Deinit of Testbed App.\n"));

    ilm_destroy();
}

void Testbed::surface_id_received_TB(unsigned int surface_id, void *user_data)
{
    (void)user_data;
    (void)surface_id;
}

void Testbed::surface_id_invalid_TB(unsigned int surface_id, void *user_data)
{
    (void)user_data;
    printf("Surface id now invalid: %u\n", surface_id);
}

void Testbed::state_changed_TB(tba_app_state_t previous_state, tba_app_state_t new_state, void *user_data)
{
    LOG_INFO((demo, "Testbed changed state from %d to %d", previous_state, new_state));

    Testbed* tbInstance = (Testbed*) user_data;
    VideoChannel* tb_video;
    tbInstance->currentAppState = new_state;

    tb_video = tbInstance->getVideoChannel();

    if(tb_video!= nullptr)
    {
        if(previous_state == TBA_STATE_BACKGROUND && new_state == TBA_STATE_FOREGROUND)
        {
            LOG_INFO((demo, "%s: Switch native HMI to background, AAUTO to foreground", __FUNCTION__));
            tb_video->getProtocolEndpoint()->setVideoFocus(VIDEO_FOCUS_PROJECTED, false);
        }
        else if (previous_state == TBA_STATE_FOREGROUND && new_state == TBA_STATE_BACKGROUND)
        {
            LOG_INFO((demo, "%s: Switch AAUTO to background, native HMI to foreground", __FUNCTION__));
            tb_video->getProtocolEndpoint()->setVideoFocus(VIDEO_FOCUS_NATIVE, false);
        }
    }
    else
    {
        LOG_ERROR((demo, "%s: Video pointer is NULL.", __FUNCTION__));
    }
}

bool Testbed::entering_shutdown_TB(int request_id, void *user_data)
{
    (void)user_data;
    (void)request_id;
    return false;
}

bool Testbed::waking_up_TB(tba_app_state_t recent_active_state, tba_app_state_t *targeted_state, int request_id, void *user_data)
{
    (void)user_data;
    (void)request_id;
    (void)*targeted_state;
    LOG_INFO((demo,"Application is requested to wake up into state: %d\n",recent_active_state));
    return true;
}

void Testbed::log_event_TB(tba_loglevel_t level, const char *msg, void *user_data)
{
    (void)user_data;
    if (level==TBA_LOGLEVEL_ERROR)
        LOG_INFO((demo,"ERROR : %s\n", msg));
    else
        LOG_INFO((demo,"%s\n", msg));
}

void Testbed::adit_testbed_available()
{
    libtestbedapp_service_available();
}

void Testbed::adit_testbed_background()
{
    libtestbedapp_send_to_background();
}

void Testbed::adit_testbed_foreground()
{
    libtestbedapp_send_to_foreground();
}

void Testbed::adit_testbed_lost()
{
    libtestbedapp_service_lost();
}

void Testbed::setDeviceState(deviceState inState)
{
    devStat = inState;
}

deviceState Testbed::getDeviceState()
{
    return devStat;
}

void Testbed::setCurrentAppState(int inCurrentAppState)
{
    currentAppState = inCurrentAppState;
}

int Testbed::getCurrentAppState()
{
    return currentAppState;
}

void Testbed::controlSurface()
{
    if (ILM_SUCCESS != ilm_surfaceSetOpacity(surfaceID, (t_ilm_float)0))
    {
        LOG_INFO((demo, "ilm_surfaceSetOpacity failed for layer %d", surfaceID));
    }
    if (ILM_SUCCESS != ilm_surfaceSetVisibility(surfaceID, (t_ilm_bool)true))
    {
        LOG_INFO((demo, "ilm_surfaceSetVisibility failed for layer %d", surfaceID));
    }
    ilm_commitChanges();

    LOG_INFO((demo, "ilm_surfaceSetVisibility is done"));
}

}

}
